withdrawals.controllers.module('withdrawals-overview',
	['xhr', 'loading_spinner'],
	() => {
		return {
			vue: true,
			name: 'gx-withdrawals-overview',
			template: '#withdrawals-overview',
			props: ['startupId'],
			data: () => ({
				page: 1,
				offset: 0,
				limit: 10,
				totalItems: 0,
				totalPages: 1,
				withdrawals: [],
				sortBy: 'id',
				sortOrder: 'desc',
				lang: {
					heading: {
						id: jse.core.lang.translate('label_column_id', 'withdrawals'),
						date: jse.core.lang.translate('label_column_date', 'withdrawals'),
						byAdmin: jse.core.lang.translate('label_column_date_by_admin', 'withdrawals'),
						byCustomer: jse.core.lang.translate('label_column_date_by_customer', 'withdrawals'),
						order: jse.core.lang.translate('label_column_order', 'withdrawals'),
						customer: jse.core.lang.translate('label_column_customer', 'withdrawals'),
					},
					limits: {
						10: jse.core.lang.translate('option_limits_10', 'withdrawals'),
						25: jse.core.lang.translate('option_limits_25', 'withdrawals'),
						50: jse.core.lang.translate('option_limits_50', 'withdrawals'),
						100: jse.core.lang.translate('option_limits_100', 'withdrawals'),
					},
					offset: {
						of: jse.core.lang.translate('label_offset_of', 'withdrawals'),
						to: jse.core.lang.translate('label_offset_to', 'withdrawals'),
					},
					page: {
						previous: jse.core.lang.translate('label_page_previous', 'withdrawals'),
						next: jse.core.lang.translate('label_page_next', 'withdrawals'),
					},
					noWithdrawalsExist: jse.core.lang.translate('no_withdrawals_exist', 'withdrawals'),
					create: jse.core.lang.translate('create', 'buttons'),
				},
				detailsWithdrawalId: undefined,
				deleteWithdrawal: undefined,
			}),
			methods: {
				loadWithdrawals() {
					if(this.startupId !== '' && Number.isInteger(parseInt(this.startupId))){
						this.detailsWithdrawalId = parseInt(this.startupId);
					}
					
					const vm = this;
					const $target = $('table.withdrawals');
					const spinner = jse.libs.loading_spinner.show($target);
					
					jse.libs.xhr.post({
						url: './admin.php?do=Withdrawals/GetWithdrawals',
						data: {
							limit: this.limit,
							offset: this.offset,
							sortOrder: this.sortOrder,
							sortBy: this.sortBy,
						}
					}).done(response => {
						vm.withdrawals = response.withdrawals;
						vm.totalItems = response.total;
						vm.totalPages = Math.ceil(vm.totalItems / vm.limit);
						jse.libs.loading_spinner.hide(spinner);
					}).fail((response) => {
						console.error('Could not load withdrawals.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_load_withdrawals', 'withdrawals'));
						jse.libs.loading_spinner.hide(spinner);
						vm.withdrawals = [];
						vm.totalItems = 0;
						vm.totalPages = 1;
					});
				},
				changeSorting(column) {
					this.sortOrder = (this.sortBy !== column)? 'desc' : (this.sortOrder === 'desc'? 'asc' : 'desc');
					this.sortBy = column;
					
					this.loadWithdrawals();
				},
				previousPage() {
					this.page = this.page === 1 ? 1 : this.page - 1;
					this.updateOffset();
					this.loadWithdrawals();
				},
				updateOffset() {
					this.offset = (this.page - 1) * this.limit;
				},
				nextPage() {
					this.page = this.page === this.totalPages ? this.totalPages : this.page + 1;
					this.updateOffset();
					this.loadWithdrawals();
				},
				openCreateModal() {
					$('.create-modal.modal').modal('show');
				},
				openDetailsModal(id) {
					this.detailsWithdrawalId = id;
					const $modal = $('.details-modal.modal');
					$modal.on('hidden.bs.modal', () => {
						this.detailsWithdrawalId = undefined;
					});
				},
				openDeleteModal(withdrawal) {
					this.deleteWithdrawal = withdrawal;
					const $modal = $('.delete-modal.modal');
					$modal.on('hidden.bs.modal', () => {
						this.deleteWithdrawal = undefined;
					});
				},
			},
			mounted() {
				this.loadWithdrawals();
			},
			init: done => done()
		}
	});